//+------------------------------------------------------------------+
//|                                             MiddleNow50%HiLo.mq4 |
//|                      Copyright  2010, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 DarkGray
#property indicator_color2 DarkGray
#property indicator_color3 Black


//---- input parameters
//---- buffers
extern bool M30=false;
extern bool Hourly=false;
extern bool Hourly4=false;
extern bool Daily=true;
extern bool Weekly=false;
extern bool Monthly=false;

double DayHiBuffer[];
double DayLoBuffer[];
double DayMidBuffer[];
double DayHi, DayLo, DayMid;

string timetext;

int init()
  {
   string short_name;
   
   if(Monthly)
      timetext= "M";
   else if(Weekly)
        timetext= "W";
   else if(Daily)
        timetext= "D";
   else if(Hourly4)
        timetext= "H4";
   else if(Hourly)
        timetext= "H";
   else if(M30)
        timetext= "M30";
   
   SetIndexLabel(0,timetext+"_Hi");
   SetIndexLabel(1,timetext+"_Lo");
   SetIndexLabel(2,timetext+"_Mid");
   
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexStyle(2,DRAW_LINE);
   
   SetIndexBuffer(0, DayHiBuffer);
   SetIndexBuffer(1, DayLoBuffer);
   SetIndexBuffer(2, DayMidBuffer);
   
   /*short_name="Day Hi-Lo levels";
   IndicatorShortName(short_name);
   SetIndexLabel(0, short_name);*/
   SetIndexDrawBegin(0,1);
   
   
   return(0);
  }


//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   ObjectsDeleteAll();  
   ObjectDelete("DayHi");
   ObjectDelete("DayLo");
   ObjectDelete("DayMid");
   
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+

        
  
  
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
  
   int limit, i, timeframe;
   
   if(Monthly)
      timeframe= PERIOD_MN1;
   else if(Weekly)
      timeframe= PERIOD_W1;
   else if(Daily)
      timeframe= PERIOD_D1;
   else if(Hourly4)
      timeframe= PERIOD_H4;
   else if(Hourly)
      timeframe= PERIOD_H1;
   else if(M30)
      timeframe= PERIOD_M30;
      
   limit=(Bars-IndicatorCounted()-1);
 
   for(i=limit; i>=0; i--)
      {
      // What daily/time bar corresponds to this chart's bar?
      int i_time = iBarShift(NULL, timeframe, Time[i]);
      // Get yesterdays daily/pretime high
      DayHi = iHigh(NULL, timeframe, i_time);
      DayLo = iLow(NULL, timeframe, i_time);
      DayMid=(DayHi + DayLo)/2;
   
        
      DayHiBuffer [i]=DayHi;
      DayLoBuffer [i]=DayLo;
      DayMidBuffer[i]=DayMid;

      }
    
      
   return(0);

  }


